      subroutine width
c*****this routine calculates equivalent widths for spectral lines
 
      include 'Chars.com'
      include 'Plotval.com'
      include 'Dataval.com'
      include 'Mathval.com'
      include 'Widpar.com'
      character fname*80
      character charstat*7
      real*8 wave,wavout,xnums(5)
      logical nogo,onelin
      data ndel/50/
 
c*****initialize some variables
      onelin = .true.
      kount = 0
      xleft = wlx(1)
      right = wlx(npx)
      up = 1.12*xmax
      down = 0.
      ndelt = ndel

c*****get the command and branch to the appropriate section of code
20    prompt = 'WIDTH:    '
      call getcom
      if (command .eq. 'ab' .or. command(1:1) .eq. 'a') go to 165
      if (command .eq. 'cd') go to 15
      if (command .eq. 'd0') go to 30
      if (command .eq. 'lf') go to 60
      if (command .eq. 'ln') go to 45
      if (command .eq. 'ml') go to 75
      if (command .eq. 'ul') go to 90
      if (command .eq. 'he') go to 105
      if (command .eq. 'rc') go to 120
      if (command .eq. 'sr') go to 150
      if (command .eq. 'np') go to 135
      if (command .eq. 'qu' .or. command(1:1) .eq. 'q') go to 165
      errmess = 'UNKNOWN WIDTH COMMAND; TRY AGAIN! '
      nchars = 34
      call puterr (nchars)
      go to 20

c*****here the continuum is defined for the width measures
15    call contin ('dv',nogo,.false.)
      go to 20

c*****here the whole plot is redone: all points, intensities from zero
30    call minimax (x,xmin,xmax,npx)
      xleft = wlx(1)
      right = wlx(npx)
      up = 1.12*xmax
      down = 0.
      call plotxy (1,1,wlx,x,npx,1)
      go to 20

c*****here the equivalent width of a single line is determined
45    mode = 1
46    onelin = .true.
      kount = kount + 1
47    message = 'LINE WAVELENGTH = '
      nchars = 18
      call getnum (nchars,wave)
      if (wave .eq. -9999.) go to 47
      eqwdth = -9999.
49    call single (mode,wave,wavout,ipt,depth,halfl,halfr,eqwdth)
51    call record (kount,onelin,wave,wavout,depth,halfl,halfr,eqwdth)      
50    if (mode .eq. 2) go to 151
      message = 'IS THE LINE OK ([y],n,c,v,a)? '
      nchars = 30
      call getasci (nchars)
      if (array(1:1).eq.'y' .or. nchars.le.0) then 
         go to 20
      elseif (array(1:1) .eq. 'a') then
         go to 165 
      elseif (array(1:1) .eq. 'n') then
         go to 95
      elseif (array(1:1) .eq. 'c') then
         call newcont
         go to 49
      elseif (array(1:1) .eq. 'v') then
         call voigtfit (0,wavout,ipt,depth,halfl,halfr,eqwdth)
         go to 51
      else
         go to 50
      endif

c*****here the user can create a file containing line positions
60    write (message,2001) 
2001  format (31(' '),'LINE LIST CREATION',30(' '))
      write (array,2002)
2002  format (80(' '))
      call prinfo (1)
      message = 'GIVE THE FILE NAME FOR THE LINELIST: '
      nchars = 37
      call getasci (nchars)
      nchars = min0(nchars,80)
      fname = array(1:nchars)
      charstat = 'new    '
      call dskfil(30,iostat,fname,charstat,'sequential',
     .      'formatted  ',0)
      if (iostat .ne. 0) go to 20
      write (array,2003)
2003  format ('BELOW, ENTER THE WAVELENGTH LIST.  ANY NEGATIVE '
     .        'NUMBER ENDS THE LIST. ',10x)
      call prinfo (4)
64    message = 'LINE WAVELENGTH = '
      nchars = 18
      call getnum (nchars,wave)
      if (wave .eq. -9999.) go to 64
      if (wave .lt. 0.) go to 66
      write (30,1001) wave
1001  format(f15.3)
      go to 64
66    rewind 30
      write (array,2005) fname
2005  format ('HERE IS THE LIST OF LINES IN FILE ',a40,6x)
      call prinfo (4)
      jount = 1
69    do 67 i=1,5
67       read (30,1001,end=68) xnums(i)
      write (array,2004) (xnums(j),j=1,5)
2004  format (5f15.3)
      call prinfo (4+jount)
      jount = jount + 1
      go to 69
68    i = i - 1
      write (array,2004) (xnums(j),j=1,i)
      call prinfo (4+jount)
      close (30)
      go to 20

c*****here the equivalent widths of a whole set of lines, read from a
c     disk file, will be done.
75    mode = 1
      onelin = .false.
      message = 'GIVE THE FILE NAME OF THE INPUT LINELIST: '
      nchars = 42
      call getasci (nchars)
      nchars = min0(nchars,80)
      fname = array(1:nchars)
      charstat = 'old    '
      call dskfil(30,iostat,fname,charstat,'sequential',
     .      'formatted  ',0)
      if (iostat .ne. 0) go to 20
      message = 'GIVE THE FILE NAME FOR EQUIVALENT WIDTH OUTPUT: '
      nchars = 48
      call getasci (nchars)
      nchars = min0(nchars,80)
      fname = array(1:nchars)
      charstat = 'new    '
      call dskfil(31,iostat,fname,charstat,'sequential',
     .      'formatted  ',0)
      if (iostat .ne. 0) go to 20
      kount = 0
      call record (kount,onelin,wave,wavout,depth,halfl,halfr,eqwdth)
85    kount = kount + 1
      read (30,1001,end=25) wave
      eqwdth = -9999.
82    call single (mode,wave,wavout,ipt,depth,halfl,halfr,eqwdth)
      call record (kount,onelin,wave,wavout,depth,halfl,halfr,eqwdth)
80    message = 'IS THE LINE OK ([y],n,c,v,s,o,a)? '
      nchars = 34
      call getasci (nchars)
      if (array(1:1).eq.'y' .or. nchars.le.0) then
         go to 85
      elseif (array(1:1) .eq. 'a') then
         close (30)
         close (31)
         go to 165
      elseif (array(1:1) .eq. 's') then
         go to 25
      elseif (array(1:1) .eq. 'o') then
         eqwdth = -9999.
         call record (kount,onelin,wave,wavout,depth,halfl,halfr,eqwdth)
         go to 85
      elseif (array(1:1) .eq. 'n') then
         go to 95
      else if (array(1:1) .eq. 'c') then
         go to 97
      endif
      go to 80
97    call newcont
      go to 82
25    kount = 0
      call record (kount,onelin,wave,wavout,depth,halfl,halfr,eqwdth)
      close (30)
      close (31)
      go to 20

c*****Here the equivalent width of a line is done manually from
c     keyboard cursor placement
90    mode = 0
      onelin = .true.
      kount = kount + 1
91    message = 'LINE POSITION = '
      nchars = 16
      call getnum (nchars,wave)
      if (wave .eq. -9999.) go to 91
      call single (mode,wave,wavout,ipt,depth,halfl,halfr,eqwdth)
95    call manual (0,ipt,wavout,depth,halfl,halfr,eqwdth)
      call record (kount,onelin,wave,wavout,depth,halfl,halfr,eqwdth)
      if (onelin) go to 50
      go to 80

c*****here a list of WIDTH commands are displayed on the screen
105   call printh('widhelp')
      go to 20

c*****here the original continuum is reset
120   call setre (0,ycont)
      do 55 i=1,npx
55       x(i) = x(i)*ycont
      go to 20

c*****here the number of data points displayed is altered
135   message = 'DESIRED NUMBER OF POINTS TO BE PLOTTED = '
      nchars = 41
      call getnum (nchars,wave)
      if (wave .eq. -9999.) go to 135
      ndelt = int(sngl(wave))
      ndel = ndelt
      go to 20

c*****Here the line integration is done brute-force by Simpson's Rule
150   mode = 2
      go to 46
151   message = 'IS THE LINE OK ([y],c,a)? '
      nchars = 26
      call getasci (nchars)
      if (array(1:1).eq.'y' .or. nchars.le.0) then
         go to 20
      elseif (array(1:1) .eq. 'c') then
         call newcont
         go to 49
      elseif (array(1:1) .eq. 'a') then
         go to 165
      else
         go to 151
      endif

c*****reset the plot boundaries and return
165   xleft = wlx(1)
      right = wlx(npx)
      up = 1.12*xmax
      down = 0.
      return

      end






