
      subroutine h2omake
c*****this routine makes an H2O telluric spectrum near the Na D lines,
c     and puts it in the y-array.  The x-array must be at least partially
c     in the 5868-5917A region over which the H2O spectrum is defined.
c     The H2O line data are from I. Lundstr"om, A. Ardeberg, E. Maurice, 
c     & H. Lindgren, 1991, A&A, 91, 199. 
c     A Gaussian smearing function will be assumed; 
c     this function is to represent the combined effects of a) the 
c     Doppler widths of the telluric lines, and b) the spectrograph 
c     slit function.

      include 'Dataval.com'
      include 'Datachr.com'
      include 'Mathval.com'
      include 'Plotval.com'
      include 'Chars.com'
      real*8 fwhm, sigma, aa, depth 
      real*8 wavelo, wavehi
      real*4 p(1000)
      equivalence (p,scratch)
      real*8 wavh2o(222)
      real*4 ewh2o(222)
      data (wavh2o(i),ewh2o(i),i=  1, 30)/
     *  5868.5876, 0.0440, 5868.7598, 0.1080, 5869.0015, 0.0580,
     *  5869.2688, 0.0450, 5869.4476, 0.0640, 5869.6570, 0.0800,
     *  5869.8523, 0.1040, 5870.1123, 0.0550, 5870.2411, 0.0390,
     *  5870.3918, 0.0380, 5870.6293, 0.2150, 5870.8282, 0.0440,
     *  5871.0077, 0.0510, 5871.1603, 0.0810, 5871.2946, 0.1360,
     *  5871.7371, 0.0240, 5871.8842, 0.0290, 5872.0013, 0.0280,
     *  5872.1204, 0.0400, 5872.2839, 0.0470, 5872.5433, 0.0410,
     *  5872.6959, 0.0320, 5872.8967, 0.0630, 5873.0841, 0.0410,
     *  5873.1946, 0.0380, 5873.3032, 0.0610, 5873.5760, 0.1300,
     *  5873.7744, 0.0470, 5873.9673, 0.0630, 5874.2450, 0.0420/
      data (wavh2o(i),ewh2o(i),i= 31, 60)/
     *  5874.4714, 0.0420, 5874.6393, 0.0480, 5874.8053, 0.0280,
     *  5875.0330, 0.0170, 5875.1404, 0.1030, 5875.4730, 0.0620,
     *  5875.5878, 0.1650, 5875.8240, 0.0390, 5876.0022, 0.0430,
     *  5876.1218, 0.2370, 5876.4313, 0.1700, 5876.6718, 0.0280,
     *  5876.8903, 0.0170, 5877.0569, 0.0520, 5877.3279, 0.0910,
     *  5877.5531, 0.0690, 5877.8082, 0.0100, 5877.9077, 0.0160,
     *  5878.3582, 0.0400, 5878.5846, 0.0430, 5878.8165, 0.0600,
     *  5879.0515, 0.0410, 5879.2017, 0.0980, 5879.4006, 0.0550,
     *  5879.6027, 0.2260, 5879.7205, 0.2210, 5879.8456, 0.0150,
     *  5879.9847, 0.0520, 5880.1868, 0.0250, 5880.3088, 0.0390/
      data (wavh2o(i),ewh2o(i),i= 61, 90)/
     *  5880.5090, 0.0630, 5880.7312, 0.1370, 5880.9265, 0.2430,
     *  5881.0938, 0.1630, 5881.2701, 0.0240, 5881.3855, 0.0320,
     *  5881.5118, 0.0370, 5881.7169, 0.0710, 5881.8658, 0.2700,
     *  5881.9836, 0.1720, 5882.1808, 0.0410, 5882.3706, 0.0960,
     *  5882.4902, 0.0970, 5882.6740, 0.0430, 5882.8033, 0.2450,
     *  5883.0035, 0.1840, 5883.1073, 0.0350, 5883.3429, 0.0410,
     *  5883.5809, 0.0450, 5883.7970, 0.1250, 5883.9050, 0.4950,
     *  5884.0613, 0.0470, 5884.2126, 0.1590, 5884.4574, 0.0490,
     *  5884.7156, 0.0490, 5884.9011, 0.0380, 5885.4913, 0.1420,
     *  5885.6207, 0.1560, 5885.9778, 0.7930, 5886.3379, 0.2300/
      data (wavh2o(i),ewh2o(i),i= 91,120)/
     *  5886.4056, 0.1490, 5886.6840, 0.2220, 5886.8872, 0.0540,
     *  5887.2223, 0.7370, 5887.5500, 0.0510, 5887.6587, 0.5230,
     *  5887.8583, 0.0720, 5888.2440, 0.0410, 5888.4143, 0.0330,
     *  5888.7067, 0.3760, 5889.0857, 0.0810, 5889.6375, 0.6510,
     *  5889.8578, 0.0800, 5889.9457, 0.0570, 5890.0818, 0.5720,
     *  5890.2283, 0.1160, 5890.3357, 0.0780, 5890.5359, 0.0680,
     *  5890.7141, 0.0980, 5890.8960, 0.0640, 5891.1584, 0.1570,
     *  5891.5002, 0.2030, 5891.6559, 0.8380, 5892.0343, 0.0610,
     *  5892.2565, 0.0310, 5892.3944, 0.6310, 5892.6361, 0.0550,
     *  5893.0408, 0.3650, 5893.3453, 0.0230, 5893.5083, 0.3830/
      data (wavh2o(i),ewh2o(i),i=121,150)/
     *  5893.6584, 0.0290, 5894.3872, 0.2610, 5894.5630, 0.0600,
     *  5894.8267, 0.0460, 5894.9542, 0.2330, 5895.1361, 0.1910,
     *  5895.9253, 0.0610, 5896.1212, 0.0510, 5896.3147, 0.0450,
     *  5896.4203, 0.1470, 5896.4880, 0.3240, 5896.8323, 0.4960,
     *  5897.0886, 0.0780, 5897.1802, 0.0420, 5897.4646, 0.2230,
     *  5897.7551, 0.0770, 5897.9303, 0.0910, 5898.1573, 0.7390,
     *  5898.3984, 0.0720, 5898.7732, 0.0590, 5898.9978, 0.4860,
     *  5899.5471, 0.0420, 5899.9170, 0.4350, 5900.0366, 0.8370,
     *  5900.4272, 0.0750, 5900.5927, 0.0400, 5900.7397, 0.0340,
     *  5900.9174, 0.1150, 5901.2457, 0.1590, 5901.4612, 1.0000/
      data (wavh2o(i),ewh2o(i),i=151,180)/
     *  5902.0264, 0.0900, 5902.1350, 0.3020, 5902.2620, 0.0550,
     *  5902.5183, 0.0720, 5902.6434, 0.0480, 5902.8107, 0.0540,
     *  5903.5339, 0.2830, 5903.7042, 0.0680, 5903.8531, 0.0990,
     *  5903.9612, 0.0660, 5904.0613, 0.0210, 5904.2383, 0.0230,
     *  5904.3671, 0.0590, 5904.4995, 0.0210, 5904.6362, 0.0370,
     *  5904.8352, 0.0380, 5905.1147, 0.1200, 5905.2917, 0.1910,
     *  5905.3760, 0.1010, 5905.5499, 0.0550, 5905.7410, 0.0310,
     *  5905.9222, 0.0350, 5906.1615, 0.0590, 5906.3049, 0.0720,
     *  5906.5857, 0.0220, 5906.7578, 0.0320, 5907.0007, 0.0950,
     *  5907.2626, 0.2180, 5907.3572, 0.0980, 5907.4744, 0.1110/
      data (wavh2o(i),ewh2o(i),i=181,210)/
     *  5907.6477, 0.0290, 5907.8381, 0.3210, 5908.0414, 0.0390,
     *  5908.2052, 0.3240, 5908.3551, 0.0450, 5908.5681, 0.0470,
     *  5908.7714, 0.0290, 5908.9948, 0.5410, 5909.4452, 0.0950,
     *  5909.8035, 0.0360, 5910.0006, 0.0550, 5910.1874, 0.2990,
     *  5910.3094, 0.1060, 5910.4810, 0.0770, 5910.6335, 0.1220,
     *  5910.7635, 0.4580, 5910.9131, 0.0390, 5911.2134, 0.0430,
     *  5911.4502, 0.0520, 5911.6168, 0.0300, 5911.7371, 0.0300,
     *  5911.8658, 0.0800, 5912.0093, 0.1010, 5912.5403, 0.0710,
     *  5912.6868, 0.1920, 5912.9919, 0.4880, 5913.1750, 0.0180,
     *  5913.4210, 0.0210, 5913.6292, 0.0250, 5913.8037, 0.0360/
      data (wavh2o(i),ewh2o(i),i=211,222)/
     *  5914.1895, 0.3660, 5914.4855, 0.0470, 5914.6509, 0.0180,
     *  5914.9255, 0.3000, 5915.4297, 0.3470, 5915.6287, 0.2850,
     *  5915.8496, 0.0320, 5916.0248, 0.0860, 5916.3434, 0.0300,
     *  5916.5802, 0.1540, 5916.7639, 0.0390, 5916.8781, 0.0400/

c*****set up parameters, and make sure the x-array overlaps in wavelength
      ntot = 222
      min = 1
      max = ntot
      wavelo = 5868.0
      wavehi = 5917.0
      if (wlx(1).gt.wavehi-1.0 .or. wlx(npx).lt.wavelo+1.0) then
         write (errmess,1003) 
1003     format ('NO OVERLAP! H2O SPECTRUM ONLY DEFINED 5868-5916A!')
         nchars = 49
         call puterr (nchars)
         return
      endif

c*****ask for the parameters of the Gaussian fit.
10    message = 'GIVE THE TYPICAL FWHM (A) OF THE H2O LINES: '
      nchars = 44
      call getnum (nchars,fwhm)
      if (fwhm .eq. -9999.) go to 10
      if (fwhm .le. 0.) return
15    message = 'GIVE THE TYPICAL DEPTH OF STRONG H2O LINES: '
      nchars = 44
      call getnum (nchars,depth)
      if (depth .eq. -9999.) go to 15
      if (depth .le. 0.) return

c*****compute the Gaussian function
      sigma = fwhm/2
      aa = 0.6932/sigma**2
      step = 0.001
      do i=1,1000
         p(i) = depth*dexp(-aa*(step*i)**2 )
      enddo
      if (p(1000) .gt. 0.02*p(1)) then
         write (errmess,1001) fwhm
1001     format ('GAUSSIAN TOO BIG! HALF WIDTH=',f6.2)
         nchars = 35
         call puterr (nchars)
         return
      endif

c*****compute the smoothed spectrum
      npy = npx
      do i=1,npy
         wly(i) = wlx(i)
         if (wly(i) .lt. wavelo) then
            y(i) = 1.
         elseif (wly(i) .gt. wavehi) then
            y(i) = 1.
         else
25          do j=min,ntot
               if (wavh2o(j) .ge. wly(i)-1.) then
                  min = j
                  go to 20
               endif
            enddo
            min = ntot
20          do j=min,ntot
               if (wavh2o(j) .gt. wly(i)+1.) then
                  max = j - 1
                  go to 30
               endif
            enddo
            max = ntot
30          y(i) = 1.
            do j=min,max
               ndelta = idint(dabs(1000.*(wly(i)-wavh2o(j))+0.5))
               if (ndelta .eq. 0) then
                  y(i) = y(i) - depth*ewh2o(j)
               else
                  y(i) = y(i) - p(ndelta)*ewh2o(j)
               endif
            enddo
         endif
      enddo

c*****attach necessary other information to the new y-array
      do i=1,9
         dispy(i) = dispx(i)
      enddo
      yobj   = 'telluric spectrum   '
      ykfnam = '                    '
      yfname = '(no file)           '
      yary   = '  1'
  
c*****plot the x- and y-arrays, and exit the routine
      call minimax (x,xmin,xmax,npx)
      up = 1.12*xmax
      down = 0.
      xleft = wlx(1)
      right = wlx(npx)
      call plotxy (1,1,wlx,x,npx,1)
      call plotxy (1,-1,wly,y,npy,2)
      return

      end




